#include "StdV3D.h"
#include "BlobTransformable.h"


namespace V3D {


                           /////////////////////////////



BlobTransformable::BlobTransformable(float fCenterEnergy, 
                                     const Vector3D& vcPos, 
                                     float fInfluenceRange,
                                     EEvalType etStyle /* = BlobBase::etPolynom4 */)
: parent( fCenterEnergy, etStyle )
{
	SetInfluenceRange( fInfluenceRange );
	SetPosition( vcPos );
}

                           /////////////////////////////


void BlobTransformable::SetTransform( const MatrixTransf& transf)
{
	m_matTransfBaseShape = transf;
	m_matTransfBaseShapeInv = transf;
	m_matTransfBaseShapeInv.Invert(); 
	m_matTransfBaseShapeNormals = m_matTransfBaseShape.GetNormalsTransform();
	NotifyBoundsChange();
	OnTransformChanged();
}

                           /////////////////////////////


void BlobTransformable::SetPosition( const Vector3D& pos)
{
	MatrixTransf transf = m_matTransfBaseShape;
	transf.SetTranslation(pos.x, pos.y, pos.z); 
	SetTransform(transf);
}

                           /////////////////////////////


void BlobTransformable::SetInfluenceRange(float fInfl)
{
	MatrixTransf transf;
	transf.MakeDiagonal( fInfl, fInfl, fInfl);
	SetTransform(transf); 
}

                           /////////////////////////////


// Calcule une a une les energies d'un tableau de points. Permet de gagner en vitesse
// (evite la multiplication des appels a une fonction virtuelle, donc non inline)
void BlobTransformable::EnergyAddAtGrid( float* pafAddEnergies, 
								const Vector3D& vcVolStart, const Vector3D& vcSteps,
								int32 nSizeX, int32 nSizeY, int32 nSizeZ) const
{
	// Dtermination de la partie intressante du cube  visiter
	// (on visite le sous-cube minimal contenant la metaballe)
	LengthType fVolSizeX = LengthType((nSizeX - 1) * vcSteps.x);
	LengthType fVolSizeY = LengthType((nSizeY - 1) * vcSteps.y);
	LengthType fVolSizeZ = LengthType((nSizeZ - 1) * vcSteps.z);
	
	const Vector3D vcVolSize(fVolSizeX, fVolSizeY, fVolSizeZ); 

	// On se sert des positions min et max du cube englobant de la forme de base (repere (vcVolStart, d'echelle vcSteps))
//	Vector3D vcBallMin, vcBallMax;
//	bool bBlobBounded = GetBlobBounds(vcBallMin, vcBallMax);

	Vector3D vcVolEnd = vcVolStart; vcVolEnd += vcVolSize; 

	const BoundAabb& boundsBlob = GetBlobBounds();
//	bool bIntersectionNotEmpty = boundsBlob.Intersects(vcVolStart, vcVolEnd);
//	if( ! bIntersectionNotEmpty )
//		return;

	BoundAabb blobBoundsInBigBox = boundsBlob;
//	blobBoundsInBigBox.Intersection(vcVolStart, vcVolEnd);

	bool bIntersectionNotEmpty = blobBoundsInBigBox.Intersects(vcVolStart, vcVolEnd);
	if( ! bIntersectionNotEmpty)
		return;

	blobBoundsInBigBox.Intersection(vcVolStart, vcVolEnd);

	blobBoundsInBigBox.Translate( -vcVolStart);

	const Vector3D& vcBallMin = blobBoundsInBigBox.GetMin();
	const Vector3D& vcBallMax = blobBoundsInBigBox.GetMax();

	// On calcule les indices qui nous interessent du volume fourni en parametre
	int32 nStartIndexX = FloorFast(vcBallMin.x / vcSteps.x);
	int32 nStartIndexY = FloorFast(vcBallMin.y / vcSteps.y);
	int32 nStartIndexZ = FloorFast(vcBallMin.z / vcSteps.z);
	int32 nStopIndexX  = CeilFast(vcBallMax.x / vcSteps.x);
	int32 nStopIndexY  = CeilFast(vcBallMax.y / vcSteps.y);
	int32 nStopIndexZ  = CeilFast(vcBallMax.z / vcSteps.z);
	
	Vector3D vcStart( vcVolStart.x + vcSteps.x * LengthType(nStartIndexX),
	                  vcVolStart.y + vcSteps.y * LengthType(nStartIndexY),
                      vcVolStart.z + vcSteps.z * LengthType(nStartIndexZ) );

	int32 nLinesCount = nStopIndexY - nStartIndexY + 1;
	int32 nLineLength = nStopIndexX - nStartIndexX + 1;

	Vector3D vcRectTransfAxisX; vcRectTransfAxisX.Set( m_matTransfBaseShapeInv.GetColumnX() * vcSteps.x );
	Vector3D vcRectTransfAxisY; vcRectTransfAxisY.Set( m_matTransfBaseShapeInv.GetColumnY() * vcSteps.y );
	Vector3D vcRectTransfAxisZ; vcRectTransfAxisZ.Set( m_matTransfBaseShapeInv.GetColumnZ() * vcSteps.z );
	
	Vector3D vcCur = m_matTransfBaseShapeInv * vcStart;

	for( int32 iCurZ = nStartIndexZ; iCurZ <= nStopIndexZ; ++iCurZ, vcCur += vcRectTransfAxisZ)
	{
		int32 iCurEnergyPlane = nStartIndexX + nSizeX * (nStartIndexY + nSizeY * iCurZ);

		float* pafLocalAddEnergies = pafAddEnergies+iCurEnergyPlane;
		
		//		EnergyAddAtRectanglePos( pafAddEnergies+iCurEnergyPlane, vcCur, vcSteps, nLinesCount, nLineLength, nSizeX);
		EnergyBaseShapeAddAtRectangle( pafLocalAddEnergies, 
			                           vcCur, vcRectTransfAxisX, vcRectTransfAxisY,
			                           nLinesCount, nLineLength, nSizeX);
	}
}


                           /////////////////////////////


// Fonction fournie generique mais il est fortement conseille de la redefinir (performances!)

void BlobTransformable::EnergyBaseShapeAddAtRectangle ( float* pafAddEnergies,    // Tableau des valeurs energetiques de la grille
										 const Vector3D& vcRectStart,  // Origine du rectangle
										 const Vector3D& vcRectAxisX,  // Axe X du rectangle (sert d'unite de separation entre deux calculs d'energie)
										 const Vector3D& vcRectAxisY,  // Axe Y du rectangle (sert d'unite de separation entre deux calculs d'energie)
                                         int32 nLinesCount,            // Nombre de subdivisions en Y dans le rectangle
										 int32 nLineLength,            // Nombre de subdivisions en X dans le rectangle
										 int32 nSizeX                  // Nombre de subdivisions en X dans la grille
										) const
{
	Vector3D vcStartCurLine = vcRectStart;
	for(int32 j = 0; j < nLinesCount; ++j, vcStartCurLine += vcRectAxisY)
	{
		int32 nFirstPointInLine = j * nSizeX;
		Vector3D vcCurPoint = vcStartCurLine;

		for(int32 i = 0; i < nLineLength; ++i)
		{
			EnergyAddAtPosBaseShape( pafAddEnergies[nFirstPointInLine+i], vcCurPoint);
			vcCurPoint += vcRectAxisX;
		}
		
	}
}



} // namespace

